var pie R x z xi kappa; 	  

varexo eps_z eps_r;   

parameters alpha beta phi_x phi_pie rho_r rho_z sigma sigma_z sigma_r theta omega; // DECLARATION OF THE DEEP PARAMETERS.

// Parameter Values
alpha   = 0.005;  
beta    = 0.99;
phi_x   = 0.125;
phi_pie = 1.5;
rho_r   = 0.75;
rho_z   = 0.9;
sigma   = 1;
sigma_z = 0.3;
sigma_r = 0.2;
theta   = 6;
omega   = 1;


// DECLARATION OF THE (LINEAR) DSGE MODEL: 
model;

    kappa       = ((1-alpha)*(1-alpha*beta)*(omega+theta))/(alpha*sigma*(omega+theta));
    pie         = kappa*x + beta*pie(+1);
    x(+1) - x   = sigma*(R - pie(+1) -z);
    R           = rho_r*R(-1) + (1-rho_r)*phi_pie*pie + (1-rho_r)*phi_x*x + xi;
    z           = rho_z*z(-1) + sigma_z*eps_z;
	xi          = sigma_r*eps_r;

end;

shocks;
var eps_z;
stderr 1;
var eps_r;
stderr 1;
end;

set_dynare_seed('clock');

stoch_simul(order = 1, periods = 1232, simul_replic = 500, nograph, noprint);

[sim_array]=get_simul_replications(M_,options_);
y_sim=squeeze(sim_array(strmatch('y',M_.endo_names,'exact'),:,:));
